/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.ReinforcedModifier;

public class TemperateModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_MINING_BOOST = 7.5f;
    private static final float MAX_DRAWSPEED_BOOST = 0.15f;
    private static final class_2561 SPEED = TConstruct.makeTranslation("modifier", "temperate.speed");
    private static final class_2561 REINFORCED = TConstruct.makeTranslation("modifier", "temperate.reinforced");

    private static float getBonus(class_1309 living, class_2338 pos, int level) {
        return (((class_1959)living.method_37908().method_23753(pos).comp_349()).method_21740(pos) - 0.75f) * (float)level / 1.25f;
    }

    @Override
    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable class_1309 holder) {
        float bonus;
        if (holder != null && (bonus = TemperateModifier.getBonus(holder, holder.method_24515(), level)) > 0.0f) {
            return ReinforcedModifier.damageReinforced(amount, ReinforcedModifier.diminishingPercent(bonus * 2.0f));
        }
        return amount;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvents.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        float bonus;
        if (isEffective && (bonus = TemperateModifier.getBonus((class_1309)event.getPlayer(), event.getPos(), level)) < 0.0f) {
            event.setNewSpeed(event.getNewSpeed() - bonus * 7.5f * tool.getMultiplier(ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.DRAW_SPEED && (bonus = TemperateModifier.getBonus(living, living.method_24515(), modifier.getLevel())) < 0.0f) {
            baseValue -= bonus * 0.15f * multiplier;
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            float bonus = player != null && key == TooltipKey.SHIFT ? TemperateModifier.getBonus((class_1309)player, player.method_24515(), level) : (float)(-level);
            if (bonus < -0.01f) {
                if (harvest) {
                    this.addFlatBoost(SPEED, -bonus * tool.getMultiplier(ToolStats.MINING_SPEED) * 7.5f, tooltip);
                } else {
                    this.addFlatBoost(SPEED, -bonus * tool.getMultiplier(ToolStats.DRAW_SPEED) * 0.15f, tooltip);
                }
            }
            if (bonus > 0.01f) {
                tooltip.add((class_2561)this.applyStyle(class_2561.method_43470((String)(Util.PERCENT_FORMAT.format(ReinforcedModifier.diminishingPercent(bonus * 2.0f)) + " ")).method_10852(REINFORCED)));
            }
        }
    }
}

